<?php
include "config.php";
if (!isset($_SESSION["admin"])) {
  header("Location: login");
  exit;
}

// Tentukan provider
$provider = $_GET['provider'] ?? 'evo';
$fileMap = [
  "evo" => "games_evo.json",
  "habanero" => "games_habanero.json",
  "pragmatic" => "games_pragmatic.json",
  "pgsoft" => "games_pgsoft.json",
  "CQ9" => "games_CQ9.json",
  "spadegaming" => "games_spadegaming.json",
  "joker" => "games_joker.json",
  "playtech" => "games_playtech.json",
  "microgaming" => "games_microgaming.json",
  "netent" => "games_netent.json",
  "yggdrasil" => "games_yggdrasil.json",
  "redtiger" => "games_redtiger.json",
  "nolimitcity" => "games_nolimitcity.json"
];

if (!isset($fileMap[$provider])) {
  die("Provider tidak dikenal!");
}

$gamesFile = __DIR__ . "/" . $fileMap[$provider];
$games = file_exists($gamesFile) ? json_decode(file_get_contents($gamesFile), true) : [];

$msg = "";
$icon = "success";

// --- Tambah Game ---
if ($_SERVER["REQUEST_METHOD"] === "POST" && $_POST["action"] === "add") {
  $newImg = trim($_POST["img"]);
  $newAlt = trim($_POST["alt"]);

  $isDuplicate = false;
  foreach ($games as $g) {
    if ($g["img"] === $newImg || strcasecmp($g["alt"], $newAlt) === 0) {
      $isDuplicate = true;
      break;
    }
  }

  if ($isDuplicate) {
    header("Location: games_edit?provider={$provider}&msg=" . urlencode("⚠️ Game sudah ada!") . "&icon=error");
    exit;
  }

  $games[] = ["img" => $newImg, "alt" => $newAlt];
  file_put_contents($gamesFile, json_encode($games, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE));

  // ✅ tampilkan nama alt di pesan sukses
  header("Location: games_edit?provider={$provider}&msg=" . urlencode("✅ Game '{$newAlt}' berhasil ditambahkan!") . "&icon=success");
  exit;
}

// --- Hapus Game ---
if (isset($_GET["delete"])) {
  $id = intval($_GET["delete"]);
  if (isset($games[$id])) {
    unset($games[$id]);
    $games = array_values($games);
    file_put_contents($gamesFile, json_encode($games, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE));
  }
  header("Location: games_edit?provider={$provider}&msg=" . urlencode("🗑 Game berhasil dihapus!") . "&icon=success");
  exit;
}

// --- Edit Game ---
if ($_SERVER["REQUEST_METHOD"] === "POST" && $_POST["action"] === "edit") {
  $id = intval($_POST["id"]);
  $editImg = trim($_POST["img"]);
  $editAlt = trim($_POST["alt"]);

  $isDuplicate = false;
  foreach ($games as $index => $g) {
    if ($index == $id) continue;
    if ($g["img"] === $editImg || strcasecmp($g["alt"], $editAlt) === 0) {
      $isDuplicate = true;
      break;
    }
  }

  if ($isDuplicate) {
    header("Location: games_edit?provider={$provider}&msg=" . urlencode("⚠️ Data duplikat, tidak bisa update!") . "&icon=error");
    exit;
  }

  if (isset($games[$id])) {
    $games[$id]["img"] = $editImg;
    $games[$id]["alt"] = $editAlt;
    file_put_contents($gamesFile, json_encode($games, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE));
  }
  header("Location: games_edit?provider={$provider}&msg=" . urlencode("✅ Game berhasil diupdate!") . "&icon=success");
  exit;
}

// --- Hapus Semua Duplikat ---
if (isset($_POST["action"]) && $_POST["action"] === "delete_duplicates") {
  $uniqueSet = [];
  $filteredGames = [];

  foreach ($games as $g) {
    $key = strtolower($g["img"]) . "|" . strtolower($g["alt"]);
    if (!in_array($key, $uniqueSet)) {
      $uniqueSet[] = $key;
      $filteredGames[] = $g;
    }
  }

  $games = $filteredGames;
  file_put_contents($gamesFile, json_encode($games, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE));
  header("Location: games_edit?provider={$provider}&msg=" . urlencode("✅ Semua duplikat berhasil dihapus!") . "&icon=success");
  exit;
}

// --- Hitung Statistik Duplikat ---
$totalGames = count($games);
$uniqueSet = [];
$duplicateCount = 0;
$duplicateKeys = [];

foreach ($games as $i => $g) {
  $key = strtolower($g["img"]) . "|" . strtolower($g["alt"]);
  if (in_array($key, $uniqueSet)) {
    $duplicateCount++;
    $duplicateKeys[$i] = true;
  } else {
    $uniqueSet[] = $key;
    $duplicateKeys[$i] = false;
  }
}
$uniqueCount = $totalGames - $duplicateCount;

$msg = $_GET["msg"] ?? "";
$icon = $_GET["icon"] ?? "success";
?>
<!DOCTYPE html>
<html lang="id">

<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Kelola Game <?php echo ucfirst($provider); ?></title>
  <script src="https://cdn.tailwindcss.com"></script>
  <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
  <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
</head>

<body class="bg-gray-100 min-h-screen p-6">
  <h1 class="text-2xl font-bold mb-4">Kelola Game <?php echo ucfirst($provider); ?></h1>

  <?php if (!empty($msg)): ?>
    <script>
      document.addEventListener("DOMContentLoaded", function() {
        Swal.fire({
          toast: true,
          position: 'top-end',
          icon: "<?php echo $icon; ?>",
          title: <?php echo json_encode($msg); ?>,
          showConfirmButton: false,
          timer: 2500,
          timerProgressBar: true
        });
      });
    </script>
  <?php endif; ?>

  <!-- Form Tambah Game -->
  <div class="bg-white p-4 rounded shadow mb-6">
    <h2 class="text-lg font-semibold mb-3">Tambah Game</h2>
    <form method="post" class="space-y-3">
      <input type="hidden" name="action" value="add">
      <div>
        <label class="block">URL Gambar:</label>
        <input type="text" name="img" required class="w-full border p-2 rounded">
      </div>
      <div>
        <label class="block">Nama Game (Alt):</label>
        <input type="text" name="alt" required class="w-full border p-2 rounded">
      </div>
      <button type="submit" class="bg-blue-600 text-white px-4 py-2 rounded">Tambah</button>
    </form>
    <a href="dashboard" class="inline-block mt-4 px-4 py-2 bg-gray-600 text-white rounded hover:bg-gray-500">⬅ Kembali ke Dashboard</a>
  </div>

  <!-- Search -->
  <div class="mb-4">
    <input type="text" id="searchBox" placeholder="Cari game berdasarkan Nama Alt atau Link Gambar..."
      class="w-full md:w-1/2 border rounded p-2">
  </div>

  <!-- Daftar Game -->
  <div class="bg-white p-4 rounded shadow">
    <h2 class="text-lg font-semibold mb-3">Daftar Game</h2>

    <!-- Statistik -->
    <div class="mb-4 p-3 bg-gray-100 rounded flex justify-between items-center">
      <div>
        <p>Total Game: <b><?php echo $totalGames; ?></b></p>
        <p>Unik: <b class="text-green-600"><?php echo $uniqueCount; ?></b></p>
        <p>Duplikat: <b class="text-red-600"><?php echo $duplicateCount; ?></b></p>
      </div>
      <?php if ($duplicateCount > 0): ?>
        <form method="post" id="deleteDuplicatesForm">
          <input type="hidden" name="action" value="delete_duplicates">
          <button type="button" onclick="confirmDeleteDuplicates()" class="bg-red-600 text-white px-4 py-2 rounded">🗑 Hapus Semua Duplikat</button>
        </form>
      <?php endif; ?>
    </div>

    <!-- Container scroll -->
    <div class="max-h-[690px] overflow-y-auto">
      <table class="w-full border-collapse border">
        <thead>
          <tr class="bg-gray-200 sticky top-0">
            <th class="border p-2">No</th>
            <th class="border p-2">Gambar</th>
            <th class="border p-2">Nama (Alt)</th>
            <th class="border p-2">Link Gambar</th>
            <th class="border p-2">Aksi</th>
          </tr>
        </thead>
        <tbody id="gameTable">
          <?php foreach ($games as $i => $game): ?>
            <tr class="hover:bg-gray-50 <?php echo $duplicateKeys[$i] ? 'bg-red-100' : ''; ?>">
              <td class="border p-2"><?php echo $i + 1; ?></td>
              <td class="border p-2"><img src="<?php echo htmlspecialchars($game['img']); ?>" alt="" class="h-12"></td>
              <td class="border p-2"><?php echo htmlspecialchars($game['alt']); ?></td>
              <td class="border p-2"><?php echo htmlspecialchars($game['img']); ?></td>
              <td class="border p-2 space-x-2">
                <form method="post" class="inline-block">
                  <input type="hidden" name="action" value="edit">
                  <input type="hidden" name="id" value="<?php echo $i; ?>">
                  <input type="text" name="img" value="<?php echo htmlspecialchars($game['img']); ?>" class="border p-1 rounded w-48 mb-1">
                  <input type="text" name="alt" value="<?php echo htmlspecialchars($game['alt']); ?>" class="border p-1 rounded w-32 mb-1">
                  <button type="submit" class="bg-green-600 text-white px-2 py-1 rounded">Simpan</button>
                </form>
                <a href="?provider=<?php echo $provider; ?>&delete=<?php echo $i; ?>"
                  class="btn-delete bg-red-600 text-white px-2 py-1 rounded"
                  data-url="?provider=<?php echo $provider; ?>&delete=<?php echo $i; ?>">Hapus</a>
              </td>
            </tr>
          <?php endforeach; ?>
          <?php if (empty($games)): ?>
            <tr>
              <td colspan="5" class="text-center p-4">Belum ada game</td>
            </tr>
          <?php endif; ?>
        </tbody>
      </table>
    </div>
  </div>

  <script>
    // Search + Highlight
    $("#searchBox").on("keyup", function() {
      let query = $(this).val().toLowerCase();
      $("#gameTable tr").each(function() {
        let altText = $(this).find("td:nth-child(3)").text().toLowerCase();
        let imgLink = $(this).find("td:nth-child(4)").text().toLowerCase();
        if (altText.includes(query) || imgLink.includes(query)) {
          $(this).show();
          $(this).find("td:nth-child(3), td:nth-child(4)").each(function() {
            let original = $(this).text();
            if (query.length > 0) {
              let regex = new RegExp("(" + query + ")", "gi");
              $(this).html(original.replace(regex, '<span class="bg-yellow-300">$1</span>'));
            } else {
              $(this).text(original);
            }
          });
        } else {
          $(this).hide();
        }
      });
    });

    // Konfirmasi hapus satuan
    document.querySelectorAll('.btn-delete').forEach(btn => {
      btn.addEventListener('click', function(e) {
        e.preventDefault();
        let url = this.getAttribute('data-url');
        Swal.fire({
          title: 'Yakin hapus?',
          text: "Game ini akan dihapus permanen!",
          icon: 'warning',
          showCancelButton: true,
          confirmButtonColor: '#d33',
          cancelButtonColor: '#3085d6',
          confirmButtonText: 'Ya, hapus!',
          cancelButtonText: 'Batal'
        }).then((result) => {
          if (result.isConfirmed) {
            window.location.href = url;
          }
        });
      });
    });

    // Konfirmasi hapus semua duplikat
    function confirmDeleteDuplicates() {
      Swal.fire({
        title: 'Hapus semua duplikat?',
        text: "Game duplikat akan dihapus otomatis!",
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#d33',
        cancelButtonColor: '#3085d6',
        confirmButtonText: 'Ya, hapus!',
        cancelButtonText: 'Batal'
      }).then((result) => {
        if (result.isConfirmed) {
          document.getElementById('deleteDuplicatesForm').submit();
        }
      });
    }
  </script>
</body>

</html>